package imi.pmf.sprint;

import java.util.ArrayList;
import java.util.List;

public class Zadatak {
    private String naziv;
    private String opis;
    private Status status;
    private int procenatZavrsenogPosla = 0;  // [0 - 100]
    private int brojPozitivnihRevizija = 0;
    private List<Zadatak> neSmePocetiPre;

    public List<Zadatak> getNeSmePocetiPre() {
        return neSmePocetiPre;
    }

    public void setNeSmePocetiPre(List<Zadatak> neSmePocetiPre) {
        this.neSmePocetiPre = neSmePocetiPre;
    }

    private List<Osoba> revizori;
    private Osoba dodeljenOsobi;

    public Osoba getDodeljenOsobi() {
        return dodeljenOsobi;
    }

    public void dodajRevizora(Osoba osoba) {
        if (revizori.contains(osoba) == false) revizori.add(osoba);
    }

    public void setDodeljenOsobi(Osoba dodeljenOsobi) {
        this.dodeljenOsobi = dodeljenOsobi;
    }

    public boolean azurirajStatus() throws BlokiranZadatakException {
        if (status == Status.KREIRAN) {
            // prezalak na u izradi
            for (Zadatak blokiranOd : neSmePocetiPre) {
                if (blokiranOd.getStatus() != Status.ZAVRSEN) {
                    throw new BlokiranZadatakException(this, blokiranOd);
                }
            }
            return true;
        } else if (status == Status.U_IZRADI) {
            // sa izrade na verifikaciju
            if (procenatZavrsenogPosla == 100) {
                status = Status.U_VERIFIKACIJI;
                return true;
            }
            return false;
        } else if (status == Status.U_VERIFIKACIJI) {
            if (brojPozitivnihRevizija > 1) {
                status = Status.ZAVRSEN;
                return true;
            }
        }
        return false;
    }

    public void vratiNaDoradu() {
        if (status == Status.U_VERIFIKACIJI && brojPozitivnihRevizija == 0) {
            status = Status.U_IZRADI;
        }
    }

    public void azurirajProcenatZavrsenogPosla(int procenat) {
        if (status == Status.U_IZRADI && procenat >= 0 && procenat <= 100) {
            this.procenatZavrsenogPosla = procenat;
            this.brojPozitivnihRevizija = 0;
        }
    }

    public void dodajPozitivnuRecenziju() {
        this.brojPozitivnihRevizija++;
    }

    public void negativnaRecenzija() {
        if (this.status == Status.U_VERIFIKACIJI) {
            this.brojPozitivnihRevizija = 0;
        }
    }

    public String getNaziv() {
        return naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public String getOpis() {
        return opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public Status getStatus() {
        return status;
    }

    public void dodajBlokirajuciZadatak(Zadatak zadatak) {
        this.neSmePocetiPre.add(zadatak);
    }

    public Zadatak(String naziv, String opis) {
        this.naziv = naziv;
        this.opis = opis;
        this.status = Status.KREIRAN;
        this.revizori = new ArrayList<>();
        this.neSmePocetiPre = new ArrayList<>();
        this.brojPozitivnihRevizija = 0;
        this.procenatZavrsenogPosla = 0;
    }

    public Zadatak(String naziv, String opis, Osoba dodeljenOsobi) {
        this(naziv, opis);
        this.dodeljenOsobi = dodeljenOsobi;
    }

}
